<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Admin VrBox</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <style>
        .header {
  position: absolute;
  top: 0;
  left: 0;
  right: 40px;
  height: 60px;
  width: 100%;
  text-align: center;
  background: white;
}

.header .logo {
  height: 100%;
  line-height: 40px;
  padding-right: 10px;
}

.header .logo img {
  height: 100%;
  vertical-align: middle;
}

.header .buttons button {
  background: none;
  border: none;
  color: white;
  font-size: 16px;
  cursor: pointer;
  margin-left: 10px;
}

.header .sidebar {
  position: absolute;
  top: 0;
  left: 0;
  height: 100%;
  width: 90px;
  background: white;
  border-right: 1px solid #ccc;
}

.header .sidebar .menuToggle {
  position: absolute;
  top: 10px;
  left: 10px;
  width: 40px;
  height: 40px;
  cursor: pointer;
  padding: 8px;
  display: flex;
  justify-content: center;
  align-items: center;
  transition: width 0.3s;
  color: black;
}
.header .sidebar .menuToggle span {
  margin: 0;
  padding: 0;
  font-size: 15px;
  display: none;
  user-select: none;
  pointer-events: none;
  width: 100%;
  text-align: left;
}
.header .sidebar.open .menuToggle span {
  display: flex;
  justify-content: start;
  align-items: center;
  gap: 5px;
}

.header .sidebar .menuToggle span .icon-hotspot {
  width: 30px;
  height: 30px;
  object-fit: contain;
  animation: float 5s infinite ease-in-out;
}

@keyframes float {
  0% {
    transform: translateY(0);
  }
  50% {
    transform: translateY(-10px);
  }
  100% {
    transform: translateY(0);
  }
}

.header .sidebar.open .menuToggle {
  width: 300px;
}

.header .sidebar .menuToggle img {
  width: 100%;
  height: 100%;
  object-fit: contain;
}

#sceneList {
  position: absolute;
  top: 60px;
  left: -220px;
  padding-top: 0;
  width: 0;
  max-height: 100%;
  overflow-x: hidden;
  overflow-y: auto;
  margin-left: 0;
  transition: width 0.3s;
  height: calc(100% - 60px);
  background-color: white;
  color: black;
  box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
  font-size: 13px;
}
#sceneList .scenes {
  background-color: white;
  color: black;
  font-size: 13px;
}
#sceneList.open {
  width: 250px;
}

#sceneList .scene.current,
.no-touch #sceneList .scene:hover {
    background: #FF4438;
    color: white;
}

.header .buttons {
  position: absolute;
  top: 0;
  right: 0;
  height: 100%;
  width: 90px;
  background: white;
  border-right: 1px solid #ccc;
}
.header .buttons button {
  width: 100%;
  height: 100%;
  padding: 8px;
  display: flex;
  justify-content: center;
  align-items: center;
}
.header .buttons button img {
  width: 30px;
  height: 30px;
  object-fit: contain;
}

#autorotateToggle{
  display: none ;
}

    </style>
</head>

<body>
      <div class="header">
    <div class="sidebar">
      <div class="menuToggle">
        <span> <img class="icon-hotspot" src="img/hotspot.webp" alt="">
          <p>Hotspots</p>
        </span>
      </div>

    </div>
    <div class="logo"><img src="img/logo.webp" alt=""></div>
    <div class="buttons">
    </div>
  </div>
    <div class="panel panel-default" style="margin-top: 60px;">
        <div class="panel-heading">VrBox 1</div>
        <div class="panel-body">
            <form method="POST" action="{{ route('vr1')}}" >
                @csrf
                <div class="form-group">
                    <label for="project">Proyecto</label>
                    <select name="project" id="project" class="form-control">
                        <option value="">Seleccione un proyecto</option>
                        <option value="proyecto1">El encanto</option>
                        <option value="proyecto2">Centro Comercial Libertad</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="device">Scenas</label>
                    <select name="scenas" id="scenas" class="form-control" required>
                        <option value="">Seleccione un dispositivo</option>
                        <optgroup id="ElEncanto1" label="El Encanto">
                        </optgroup>
                        <optgroup id="ccl" label="Centro Comercial Libertad">
                        </optgroup>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Submit</button>
            </form>
        </div>
        <div class="panel-heading">VrBox 2</div>
        <div class="panel-body">
            <form method="POST" action="{{ route('vr2')}}" >
                @csrf
                <div class="form-group">
                    <label for="project">Proyecto</label>
                    <select name="project2" id="project2" class="form-control">
                        <option value="">Seleccione un proyecto</option>
                        <option value="proyecto1">El encanto</option>
                        <option value="proyecto2">Centro Comercial Libertad</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="scenas2">Scenas</label>
                    <select name="scenas2" id="scenas2" class="form-control" required>
                        <option value="">Seleccione un dispositivo</option>
                        <optgroup id="ElEncanto2" label="El Encanto">
                        </optgroup>
                        <optgroup id="ccl2" label="Centro Comercial Libertad">
                        </optgroup>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Submit</button>
            </form>
        </div>
    </div>
    <script>
        var APP_DATA_CCL = {
            "scenes": [{
                    "id": "0-1",
                    "name": "1",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.05275865443357475,
                        "pitch": 0.25327361077536104,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "1-1b",
                    "name": "1B",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "2-3",
                    "name": "3",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.6652537549685817,
                        "pitch": 0.17392050652436986,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "3-3",
                    "name": "3",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.6505636089598106,
                        "pitch": 0.3809227784066884,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "4-5",
                    "name": "5",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.05604640959749574,
                        "pitch": 0.177845119758004,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "5-7n",
                    "name": "7N",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -1.0299316438345993,
                        "pitch": 0.18380334933706344,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "6-9",
                    "name": "9",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.18467612125310495,
                        "pitch": 0.35392825080305457,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "7-10n",
                    "name": "10N",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.6324069957889193,
                        "pitch": 0.2620862188093831,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "8-12",
                    "name": "12",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 1.6661576443402746,
                        "pitch": 0.7269929444227348,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "9-14",
                    "name": "14",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.6883360665997742,
                        "pitch": 0.13197324606215233,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "10-15",
                    "name": "15",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "11-18",
                    "name": "18",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "12-19",
                    "name": "19",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "13-20",
                    "name": "20",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "14-21",
                    "name": "21",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "15-22",
                    "name": "22",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "16-23",
                    "name": "23",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "17-24",
                    "name": "24",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": -1.5206722571715652,
                        "pitch": 0.10567088583299444,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "18-25",
                    "name": "25",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "19-26",
                    "name": "26",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "20-27",
                    "name": "27",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "21-28",
                    "name": "28",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "22-29",
                    "name": "29",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": -2.871183663035552,
                        "pitch": 0.19760929081266987,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "23-30",
                    "name": "30",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": -2.8298954680715838,
                        "pitch": 0.20265768068206746,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "24-31",
                    "name": "31",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": 0.14254013866806226,
                        "pitch": 0.07574794981170108,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "25-32",
                    "name": "32",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "26-34",
                    "name": "34",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "27-35",
                    "name": "35",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "28-36",
                    "name": "36",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "29-37",
                    "name": "37",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "30-38",
                    "name": "38",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": -1.3876986305122934,
                        "pitch": 0.07498479889896004,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "31-40",
                    "name": "40",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "32-44",
                    "name": "44",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "33-46",
                    "name": "46",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": 1.8863019028399552,
                        "pitch": 0.0925369499570543,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "34-47",
                    "name": "47",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "35-p7e",
                    "name": "P7E",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": -1.5301305627590622,
                        "pitch": 0.09125491709782452,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "36-48",
                    "name": "48",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": -1.408166836415182,
                        "pitch": 0.15068002748019715,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "37-49",
                    "name": "49",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "yaw": -1.5119774421415482,
                        "pitch": 0.12116308163161627,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "38-p3a",
                    "name": "P3A",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 1488,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                }
            ],
            "name": "Project Title",
            "settings": {
                "mouseViewMode": "drag",
                "autorotateEnabled": false,
                "fullscreenButton": false,
                "viewControlButtons": false
            }
        };

        var APP_DATA_El_ENCANTO = {
            "scenes": [{
                    "id": "0-1",
                    "name": "1",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.12469112959664841,
                        "pitch": 0.5313122056071666,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                        "yaw": -0.026687102413763597,
                        "pitch": 0.2197513920881704,
                        "rotation": 0,
                        "target": "1-2"
                    }],
                    "infoHotspots": []
                },
                {
                    "id": "1-2",
                    "name": "2",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.023307514582683098,
                        "pitch": 0.29314288353636364,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 3.0794182814800095,
                            "pitch": 0.06796634117911893,
                            "rotation": 0,
                            "target": "0-1"
                        },
                        {
                            "yaw": -0.03621090009232297,
                            "pitch": 0.029136128241390225,
                            "rotation": 0,
                            "target": "4-5"
                        },
                        {
                            "yaw": 1.7025641453012863,
                            "pitch": 0.10715977924765419,
                            "rotation": 0,
                            "target": "2-3"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "2-3",
                    "name": "3",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -3.0531637345338005,
                        "pitch": 0.15360750362297715,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 3.0052606685148566,
                            "pitch": 0.062008321481286544,
                            "rotation": 0,
                            "target": "1-2"
                        },
                        {
                            "yaw": -0.23212991314329123,
                            "pitch": 0.02143399853105521,
                            "rotation": 0,
                            "target": "3-4"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "3-4",
                    "name": "4",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.24801275548867352,
                        "pitch": 0.0750247045388619,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.041283233790505136,
                            "pitch": 0.1277562807619521,
                            "rotation": 0,
                            "target": "57-51"
                        },
                        {
                            "yaw": -1.5227860962603401,
                            "pitch": 0.08332640398482027,
                            "rotation": 0,
                            "target": "2-3"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "4-5",
                    "name": "5",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.027281699730590248,
                        "pitch": 0.13497263801812132,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.044550251650273154,
                            "pitch": 0.031210634843937157,
                            "rotation": 0,
                            "target": "6-6"
                        },
                        {
                            "yaw": 3.109004028021211,
                            "pitch": 0.03743656849842836,
                            "rotation": 0,
                            "target": "1-2"
                        },
                        {
                            "yaw": 1.750678131421612,
                            "pitch": 0.008205729286142827,
                            "rotation": 0,
                            "target": "56-49"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "5-50-area-verde",
                    "name": "50-Area verde",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.7534239291666545,
                        "pitch": 0.3869425310730925,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.1349819607578464,
                            "pitch": 1.4627637621903347,
                            "rotation": 0,
                            "target": "6-6"
                        },
                        {
                            "yaw": -3.096321004679158,
                            "pitch": 0.20496499342929653,
                            "rotation": 0,
                            "target": "4-5"
                        },
                        {
                            "yaw": 1.7715039257246659,
                            "pitch": 0.08279262970235557,
                            "rotation": 0,
                            "target": "54-47"
                        },
                        {
                            "yaw": 0.022597737267188833,
                            "pitch": 0.14850596126579418,
                            "rotation": 0,
                            "target": "11-10"
                        },
                        {
                            "yaw": -1.3065370963120255,
                            "pitch": 0.27361746569265577,
                            "rotation": 0,
                            "target": "7-7"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "6-6",
                    "name": "6",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.31044007269527896,
                        "pitch": 0.056988447163199396,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 0.02651308214416659,
                            "pitch": 0.04138131938164591,
                            "rotation": 0,
                            "target": "11-10"
                        },
                        {
                            "yaw": 2.374215608276919,
                            "pitch": 0.04332155876342014,
                            "rotation": 0,
                            "target": "5-50-area-verde"
                        },
                        {
                            "yaw": 1.779676554293406,
                            "pitch": -0.045966288237281105,
                            "rotation": 0,
                            "target": "49-42"
                        },
                        {
                            "yaw": -1.330733793987683,
                            "pitch": 0.015963932128649105,
                            "rotation": 0,
                            "target": "7-7"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "7-7",
                    "name": "7",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 3.0792415598912886,
                        "pitch": 0.23495344958576325,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.004003719774441805,
                            "pitch": 0.054734873947870355,
                            "rotation": 0,
                            "target": "6-6"
                        },
                        {
                            "yaw": -3.1252287571499586,
                            "pitch": 0.06627949714349768,
                            "rotation": 0,
                            "target": "8-8"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "8-8",
                    "name": "8",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 0.0008871117333750789,
                            "pitch": 0.0790041075190846,
                            "rotation": 0,
                            "target": "7-7"
                        },
                        {
                            "yaw": 3.098703645258343,
                            "pitch": 0.005596074349828228,
                            "rotation": 0,
                            "target": "10-9"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "9-9-b",
                    "name": "9 B",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0,
                        "pitch": 0,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                        "yaw": -0.038162960854478456,
                        "pitch": 0.1480547565063226,
                        "rotation": 0,
                        "target": "8-8"
                    }],
                    "infoHotspots": []
                },
                {
                    "id": "10-9",
                    "name": "9",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.12760081774130327,
                        "pitch": 0.5267592641503658,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 0.12239878340299981,
                            "pitch": 0.9005395841774249,
                            "rotation": 0,
                            "target": "9-9-b"
                        },
                        {
                            "yaw": 0.12823255111529264,
                            "pitch": 0.3248968914840997,
                            "rotation": 0,
                            "target": "8-8"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "11-10",
                    "name": "10",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": -0.01354657604334264,
                            "pitch": -0.012359076597586949,
                            "rotation": 0,
                            "target": "12-11"
                        },
                        {
                            "yaw": -3.126489621657278,
                            "pitch": 0.05394207184676958,
                            "rotation": 0,
                            "target": "6-6"
                        },
                        {
                            "yaw": 1.8430838991302423,
                            "pitch": 0.004776152566487113,
                            "rotation": 0,
                            "target": "53-46"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "12-11",
                    "name": "11",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": -0.05547972852508565,
                            "pitch": 0.024255157249434944,
                            "rotation": 0,
                            "target": "13-12"
                        },
                        {
                            "yaw": 3.100680077933406,
                            "pitch": 0.0422014687525909,
                            "rotation": 0,
                            "target": "11-10"
                        },
                        {
                            "yaw": 1.7531178470878386,
                            "pitch": 0.048054769973891354,
                            "rotation": 0,
                            "target": "49-42"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "13-12",
                    "name": "12",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.025282153208308955,
                        "pitch": 0.1091722414516525,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.03914833790323691,
                            "pitch": 0.043313595391461845,
                            "rotation": 0,
                            "target": "14-13"
                        },
                        {
                            "yaw": 1.7444320341689012,
                            "pitch": 0.0035062572559763083,
                            "rotation": 0,
                            "target": "19-18"
                        },
                        {
                            "yaw": -1.4476072488709004,
                            "pitch": 0.010385016490758403,
                            "rotation": 0,
                            "target": "27-22b"
                        },
                        {
                            "yaw": 3.1242264192958986,
                            "pitch": 0.042487088394491224,
                            "rotation": 0,
                            "target": "12-11"
                        },
                        {
                            "yaw": 0.9738045944973361,
                            "pitch": -0.2851232124012739,
                            "rotation": 0,
                            "target": "20-19-b"
                        },
                        {
                            "yaw": -0.8020760111243348,
                            "pitch": -0.21164026362928823,
                            "rotation": 0,
                            "target": "28-23-b"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "14-13",
                    "name": "13",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 0.06585448481657608,
                            "pitch": 0.0034635065928299014,
                            "rotation": 0,
                            "target": "15-14"
                        },
                        {
                            "yaw": 2.5389216133632653,
                            "pitch": -0.45347883936197775,
                            "rotation": 0,
                            "target": "20-19-b"
                        },
                        {
                            "yaw": -3.039523128550268,
                            "pitch": 0.02673301559425134,
                            "rotation": 0,
                            "target": "13-12"
                        },
                        {
                            "yaw": 0.8137000942543953,
                            "pitch": -0.32441004022596687,
                            "rotation": 0,
                            "target": "22-20-b"
                        },
                        {
                            "yaw": -1.4766957500486892,
                            "pitch": -0.2466440402553971,
                            "rotation": 0,
                            "target": "28-23-b"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "15-14",
                    "name": "14",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": -3.0560642902870434,
                            "pitch": 0.08125562389954943,
                            "rotation": 0,
                            "target": "14-13"
                        },
                        {
                            "yaw": 2.552672326919634,
                            "pitch": -0.3241590652757047,
                            "rotation": 0,
                            "target": "22-20-b"
                        },
                        {
                            "yaw": -2.012009196983893,
                            "pitch": -0.24420276369384908,
                            "rotation": 0,
                            "target": "29-23"
                        },
                        {
                            "yaw": -1.3508362854334717,
                            "pitch": -0.09453381278741446,
                            "rotation": 0,
                            "target": "24-21-b"
                        },
                        {
                            "yaw": 1.8782430434476964,
                            "pitch": -0.029120206221030287,
                            "rotation": 0,
                            "target": "16-15"
                        },
                        {
                            "yaw": 0.07575041800722282,
                            "pitch": 0.004409335200559639,
                            "rotation": 0,
                            "target": "30-24"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "16-15",
                    "name": "15",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -2.160505496391316,
                        "pitch": -0.024505430374881954,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -2.079137608134552,
                            "pitch": -0.054731404329896094,
                            "rotation": 0,
                            "target": "22-20-b"
                        },
                        {
                            "yaw": -1.3249524637534336,
                            "pitch": 0.01675070898969011,
                            "rotation": 0,
                            "target": "15-14"
                        },
                        {
                            "yaw": -3.100039242411217,
                            "pitch": 0.010503119408017625,
                            "rotation": 0,
                            "target": "17-16"
                        },
                        {
                            "yaw": 1.7492220635392144,
                            "pitch": -0.039953717856135995,
                            "rotation": 0,
                            "target": "42-35"
                        },
                        {
                            "yaw": 0.021036438472783914,
                            "pitch": -0.011300073883759865,
                            "rotation": 0,
                            "target": "39-32"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "17-16",
                    "name": "16",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -1.4754539009058831,
                        "pitch": 0.02933532331180011,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.0033860719443428167,
                            "pitch": 0.06091411152143422,
                            "rotation": 0,
                            "target": "16-15"
                        },
                        {
                            "yaw": -1.0848397313574623,
                            "pitch": -0.11150873394910832,
                            "rotation": 0,
                            "target": "22-20-b"
                        },
                        {
                            "yaw": -2.1370405314467504,
                            "pitch": -0.1374078718604892,
                            "rotation": 0,
                            "target": "20-19-b"
                        },
                        {
                            "yaw": -3.0949969937585564,
                            "pitch": 0.05501634117280396,
                            "rotation": 0,
                            "target": "18-17"
                        },
                        {
                            "yaw": 1.760729292260356,
                            "pitch": -0.0409538216617964,
                            "rotation": 0,
                            "target": "43-36"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "18-17",
                    "name": "17",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -1.4343758905155664,
                        "pitch": 0.03201502258586508,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.021280748082853407,
                            "pitch": 0.0058374568795898085,
                            "rotation": 0,
                            "target": "17-16"
                        },
                        {
                            "yaw": -0.5513458983121069,
                            "pitch": -0.1017944799010948,
                            "rotation": 0,
                            "target": "22-20-b"
                        },
                        {
                            "yaw": -1.700040249211618,
                            "pitch": -0.1530630733884415,
                            "rotation": 0,
                            "target": "20-19-b"
                        },
                        {
                            "yaw": -3.1007915278983624,
                            "pitch": 0.017260976070341272,
                            "rotation": 0,
                            "target": "19-18"
                        },
                        {
                            "yaw": 1.7550392718410217,
                            "pitch": -0.047943291903298046,
                            "rotation": 0,
                            "target": "44-37"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "19-18",
                    "name": "18",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.92991583122744,
                        "pitch": -0.04978844854835174,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.8432304880692918,
                            "pitch": -0.27606834028822114,
                            "rotation": 0,
                            "target": "20-19-b"
                        },
                        {
                            "yaw": -0.12241040153485905,
                            "pitch": -0.019762804740103945,
                            "rotation": 0,
                            "target": "18-17"
                        },
                        {
                            "yaw": 1.615746184677981,
                            "pitch": -0.026599117957037066,
                            "rotation": 0,
                            "target": "45-38"
                        },
                        {
                            "yaw": -1.7227642229286904,
                            "pitch": -0.033527243355479186,
                            "rotation": 0,
                            "target": "13-12"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "20-19-b",
                    "name": "19 B",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": -0.22255284730069747,
                            "pitch": 0.10418907863284055,
                            "rotation": 0,
                            "target": "20-19-b"
                        },
                        {
                            "yaw": 2.2258568901812055,
                            "pitch": 0.1982162958039222,
                            "rotation": 0,
                            "target": "15-14"
                        },
                        {
                            "yaw": 1.4501440343994396,
                            "pitch": 0.32235754055194654,
                            "rotation": 0,
                            "target": "14-13"
                        },
                        {
                            "yaw": 0.28496241631066255,
                            "pitch": 0.15808540518843373,
                            "rotation": 0,
                            "target": "13-12"
                        },
                        {
                            "yaw": -2.338745078357423,
                            "pitch": 0.10715658937643369,
                            "rotation": 0,
                            "target": "16-15"
                        },
                        {
                            "yaw": -1.525322195286428,
                            "pitch": 0.14812216644672915,
                            "rotation": 0,
                            "target": "17-16"
                        },
                        {
                            "yaw": -0.9912504417483383,
                            "pitch": 0.1460413456647931,
                            "rotation": 0,
                            "target": "18-17"
                        },
                        {
                            "yaw": -0.4618445986152846,
                            "pitch": 0.10722403123749658,
                            "rotation": 0,
                            "target": "19-18"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "21-19",
                    "name": "19",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "22-20-b",
                    "name": "20 B",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": -3.07700647151837,
                            "pitch": 0.2642224274527045,
                            "rotation": 0,
                            "target": "20-19-b"
                        },
                        {
                            "yaw": 2.737292073359642,
                            "pitch": 0.1521598044658301,
                            "rotation": 0,
                            "target": "15-14"
                        },
                        {
                            "yaw": -2.446844980148004,
                            "pitch": 0.15744259025144203,
                            "rotation": 0,
                            "target": "16-15"
                        },
                        {
                            "yaw": -1.921316889102572,
                            "pitch": 0.2390450202215355,
                            "rotation": 0,
                            "target": "17-16"
                        },
                        {
                            "yaw": -1.1448729698289384,
                            "pitch": 0.23838479237176813,
                            "rotation": 0,
                            "target": "18-17"
                        },
                        {
                            "yaw": -0.593985917412958,
                            "pitch": 0.18579407465824715,
                            "rotation": 0,
                            "target": "19-18"
                        },
                        {
                            "yaw": 0.7043058126805661,
                            "pitch": 0.215122857473645,
                            "rotation": 0,
                            "target": "13-12"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "23-20",
                    "name": "20",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "24-21-b",
                    "name": "21 B",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.5180746124039182,
                        "pitch": 0.14610473003656388,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 0.8585220306051724,
                            "pitch": 0.07240333228136109,
                            "rotation": 0,
                            "target": "29-23"
                        },
                        {
                            "yaw": 1.357165575498371,
                            "pitch": 0.06064195024662844,
                            "rotation": 0,
                            "target": "27-22b"
                        },
                        {
                            "yaw": -0.1257328790105543,
                            "pitch": 0.08923893703957297,
                            "rotation": 0,
                            "target": "15-14"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "25-21",
                    "name": "21",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "26-22-a",
                    "name": "22 A",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "27-22b",
                    "name": "22B",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.8966228185680514,
                        "pitch": 0.3590266800211488,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.07490678756253111,
                            "pitch": 0.0852329711446238,
                            "rotation": 0,
                            "target": "13-12"
                        },
                        {
                            "yaw": -0.6880943006354485,
                            "pitch": 1.4804016966545044,
                            "rotation": 0,
                            "target": "26-22-a"
                        },
                        {
                            "yaw": -1.8530817471790044,
                            "pitch": 0.06999544026744431,
                            "rotation": 0,
                            "target": "24-21-b"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "28-23-b",
                    "name": "23 B",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -2.159547735022965,
                        "pitch": 0.5564884116831248,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -2.8828122595206622,
                            "pitch": 0.1262696372912373,
                            "rotation": 0,
                            "target": "15-14"
                        },
                        {
                            "yaw": -1.3342617024017365,
                            "pitch": 0.3464689914031638,
                            "rotation": 0,
                            "target": "14-13"
                        },
                        {
                            "yaw": -0.5394980489541616,
                            "pitch": 0.1507137973846504,
                            "rotation": 0,
                            "target": "15-14"
                        },
                        {
                            "yaw": 0.8142707270080436,
                            "pitch": 0.21508618773788868,
                            "rotation": 0,
                            "target": "27-22b"
                        },
                        {
                            "yaw": 2.4602318991959873,
                            "pitch": 0.15761605551810298,
                            "rotation": 0,
                            "target": "24-21-b"
                        },
                        {
                            "yaw": -2.498184217692657,
                            "pitch": 1.5707963267948966,
                            "rotation": 0,
                            "target": "29-23"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "29-23",
                    "name": "23",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                        "yaw": 0.14692752093792372,
                        "pitch": -1.5707963267948966,
                        "rotation": 0,
                        "target": "28-23-b"
                    }],
                    "infoHotspots": []
                },
                {
                    "id": "30-24",
                    "name": "24",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.00022386654269546113,
                        "pitch": 0.023269913832121958,
                        "fov": 1.2511810696903087
                    },
                    "linkHotspots": [{
                            "yaw": 0.02385356572466968,
                            "pitch": 0.016385436056753022,
                            "rotation": 0,
                            "target": "31-25"
                        },
                        {
                            "yaw": -3.0871047138713514,
                            "pitch": 0.03913492060459056,
                            "rotation": 0,
                            "target": "15-14"
                        },
                        {
                            "yaw": 1.7617259745821698,
                            "pitch": -0.036325379802303104,
                            "rotation": 0,
                            "target": "39-32"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "31-25",
                    "name": "25",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.19102823721037332,
                        "pitch": 0.010810097552180764,
                        "fov": 1.1900337353615207
                    },
                    "linkHotspots": [{
                            "yaw": -0.006282557844917491,
                            "pitch": 0.042195844188071874,
                            "rotation": 0,
                            "target": "32-26"
                        },
                        {
                            "yaw": 3.1206987179818544,
                            "pitch": 0.08373192403478846,
                            "rotation": 0,
                            "target": "30-24"
                        },
                        {
                            "yaw": 1.7359308899883192,
                            "pitch": -0.0015342769260016098,
                            "rotation": 0,
                            "target": "38-31"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "32-26",
                    "name": "26",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 2.7183606054013856,
                        "pitch": 0.10697515640442212,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -3.0298721206660417,
                            "pitch": 0.007393966926086293,
                            "rotation": 0,
                            "target": "31-25"
                        },
                        {
                            "yaw": -0.5398622439322018,
                            "pitch": -0.27134376377746605,
                            "rotation": 0,
                            "target": "33-27-b"
                        },
                        {
                            "yaw": 0.7173299379612104,
                            "pitch": -0.23663689079197425,
                            "rotation": 0,
                            "target": "34-27"
                        },
                        {
                            "yaw": 1.8221181983750254,
                            "pitch": -0.16074319241582202,
                            "rotation": 0,
                            "target": "36-29"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "33-27-b",
                    "name": "27 B",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.6389264731751894,
                        "pitch": 0.2262859698482398,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.3643722177833588,
                            "pitch": 0.3148917756011187,
                            "rotation": 0,
                            "target": "32-26"
                        },
                        {
                            "yaw": -1.0767929943041619,
                            "pitch": 0.3471553763383799,
                            "rotation": 0,
                            "target": "34-27"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "34-27",
                    "name": "27",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.19936626726188145,
                        "pitch": 0.2540679649967075,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [],
                    "infoHotspots": []
                },
                {
                    "id": "35-28",
                    "name": "28",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -2.884924093119796,
                        "pitch": 0.5597419606437697,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                        "yaw": 3.030554784846406,
                        "pitch": 0.0345382836914645,
                        "rotation": 0,
                        "target": "32-26"
                    }],
                    "infoHotspots": []
                },
                {
                    "id": "36-29",
                    "name": "29",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": -0.9156497823302168,
                        "pitch": 0.2826408880336295,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -0.08648494736636003,
                            "pitch": 0.09389728353813709,
                            "rotation": 0,
                            "target": "38-31"
                        },
                        {
                            "yaw": 1.6077518501801666,
                            "pitch": 0.10690449475991315,
                            "rotation": 0,
                            "target": "32-26"
                        },
                        {
                            "yaw": -1.4950995782010903,
                            "pitch": -0.01669478586769202,
                            "rotation": 0,
                            "target": "37-30"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "37-30",
                    "name": "30",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.87126314096054,
                        "pitch": -0.030207573451498604,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 1.567021598216125,
                            "pitch": 0.032672489439690366,
                            "rotation": 0,
                            "target": "36-29"
                        },
                        {
                            "yaw": 0.06942126584647568,
                            "pitch": 0.08697329147944544,
                            "rotation": 0,
                            "target": "41-34"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "38-31",
                    "name": "31",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.07626226923290425,
                        "pitch": 0.2629606554451023,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 0.01150890627362422,
                            "pitch": 0.06749220681888524,
                            "rotation": 0,
                            "target": "36-29"
                        },
                        {
                            "yaw": 3.090052166308176,
                            "pitch": 0.06780394485718055,
                            "rotation": 0,
                            "target": "39-32"
                        },
                        {
                            "yaw": -1.4815209475699724,
                            "pitch": 0.08370545663685292,
                            "rotation": 0,
                            "target": "31-25"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "39-32",
                    "name": "32",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 0.018861235664383358,
                            "pitch": 0.002590600122909237,
                            "rotation": 0,
                            "target": "38-31"
                        },
                        {
                            "yaw": -1.352791253335873,
                            "pitch": 0.027001174587608645,
                            "rotation": 0,
                            "target": "30-24"
                        },
                        {
                            "yaw": -3.0851622537184955,
                            "pitch": 0.010422027207326323,
                            "rotation": 0,
                            "target": "16-15"
                        },
                        {
                            "yaw": 1.799541398393302,
                            "pitch": -0.005331172142501117,
                            "rotation": 0,
                            "target": "40-33"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "40-33",
                    "name": "33",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 3.0764223054976334,
                            "pitch": 0.031570417260351036,
                            "rotation": 0,
                            "target": "39-32"
                        },
                        {
                            "yaw": 0.008686974038184303,
                            "pitch": -0.0816292017346143,
                            "rotation": 0,
                            "target": "41-34"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "41-34",
                    "name": "34",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 1.6426903978728875,
                            "pitch": 0.12129735960311372,
                            "rotation": 0,
                            "target": "40-33"
                        },
                        {
                            "yaw": -3.04105825669121,
                            "pitch": 0.03255208605988713,
                            "rotation": 0,
                            "target": "37-30"
                        },
                        {
                            "yaw": 0.08281551884967975,
                            "pitch": 0.130565918397469,
                            "rotation": 0,
                            "target": "42-35"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "42-35",
                    "name": "35",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 3.040999045423182,
                            "pitch": 0.06696082708481654,
                            "rotation": 0,
                            "target": "41-34"
                        },
                        {
                            "yaw": 1.4489873909773907,
                            "pitch": 0.08574873490652735,
                            "rotation": 0,
                            "target": "16-15"
                        },
                        {
                            "yaw": -0.08130867657082419,
                            "pitch": 0.08818648748626501,
                            "rotation": 0,
                            "target": "43-36"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "43-36",
                    "name": "36",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 1.5829620240085074,
                            "pitch": -0.020592605960011667,
                            "rotation": 0,
                            "target": "17-16"
                        },
                        {
                            "yaw": -3.1361466510008498,
                            "pitch": -0.010343813112982048,
                            "rotation": 0,
                            "target": "42-35"
                        },
                        {
                            "yaw": 0.025347997004722345,
                            "pitch": 0.03837539915407717,
                            "rotation": 0,
                            "target": "44-37"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "44-37",
                    "name": "37",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.7089927107592136,
                        "pitch": 0.21664120141936927,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 1.6086343814571986,
                            "pitch": -0.000757609478689858,
                            "rotation": 0,
                            "target": "18-17"
                        },
                        {
                            "yaw": 3.118793539414561,
                            "pitch": -0.0028841164648767403,
                            "rotation": 0,
                            "target": "43-36"
                        },
                        {
                            "yaw": -0.013339418787815305,
                            "pitch": 0.07858255811402515,
                            "rotation": 0,
                            "target": "45-38"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "45-38",
                    "name": "38",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 1.5282289752798786,
                            "pitch": 0.08209009069280526,
                            "rotation": 0,
                            "target": "19-18"
                        },
                        {
                            "yaw": 3.1336479596843745,
                            "pitch": 0.04484515764480079,
                            "rotation": 0,
                            "target": "44-37"
                        },
                        {
                            "yaw": 0.018314251214299304,
                            "pitch": 0.08414610078586371,
                            "rotation": 0,
                            "target": "46-39"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "46-39",
                    "name": "39",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 1.5582714609225263,
                            "pitch": 0.046737329824042106,
                            "rotation": 0,
                            "target": "47-40"
                        },
                        {
                            "yaw": 3.134748528793197,
                            "pitch": 0.010715110795137761,
                            "rotation": 0,
                            "target": "45-38"
                        },
                        {
                            "yaw": 0.0005808520224803715,
                            "pitch": 0.07690429732469539,
                            "rotation": 0,
                            "target": "48-41"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "47-40",
                    "name": "40",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 1.4529143520137966,
                        "pitch": -0.06244876684604783,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                        "yaw": 1.5317960024503439,
                        "pitch": -0.04504566707624491,
                        "rotation": 0,
                        "target": "46-39"
                    }],
                    "infoHotspots": []
                },
                {
                    "id": "48-41",
                    "name": "41",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.7850816561166667,
                        "pitch": 0.20605228736368986,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 3.1179189401717924,
                            "pitch": -0.01374004405117546,
                            "rotation": 0,
                            "target": "46-39"
                        },
                        {
                            "yaw": 1.5528929191657,
                            "pitch": 0.03371122408031724,
                            "rotation": 0,
                            "target": "49-42"
                        },
                        {
                            "yaw": -0.006967742333120697,
                            "pitch": 0.07197791324167824,
                            "rotation": 0,
                            "target": "50-43"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "49-42",
                    "name": "42",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 1.6379618615439195,
                            "pitch": 0.008319224678597692,
                            "rotation": 0,
                            "target": "48-41"
                        },
                        {
                            "yaw": -1.6461648780264468,
                            "pitch": 0.005863613468383377,
                            "rotation": 0,
                            "target": "12-11"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "50-43",
                    "name": "43",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.7713392004276436,
                        "pitch": 0.3630284470143348,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": -3.1099460855281187,
                            "pitch": -0.010726930396316448,
                            "rotation": 0,
                            "target": "48-41"
                        },
                        {
                            "yaw": 1.5589873444611646,
                            "pitch": 0.11768198940880126,
                            "rotation": 0,
                            "target": "51-44"
                        },
                        {
                            "yaw": -0.014170003852754576,
                            "pitch": 0.07626731568229417,
                            "rotation": 0,
                            "target": "52-45"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "51-44",
                    "name": "44",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                        "yaw": 1.565508035377004,
                        "pitch": -0.04993073604899578,
                        "rotation": 0,
                        "target": "50-43"
                    }],
                    "infoHotspots": []
                },
                {
                    "id": "52-45",
                    "name": "45",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.8091962083510928,
                        "pitch": 0.3081006304058356,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 1.529071795326546,
                            "pitch": 0.12111986933933849,
                            "rotation": 0,
                            "target": "53-46"
                        },
                        {
                            "yaw": -0.015823748670698023,
                            "pitch": 0.11839965342288039,
                            "rotation": 0,
                            "target": "54-47"
                        },
                        {
                            "yaw": 3.122870262287692,
                            "pitch": 0.03976590777930866,
                            "rotation": 0,
                            "target": "50-43"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "53-46",
                    "name": "46",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 1.6228818121809656,
                            "pitch": -0.013879119932440176,
                            "rotation": 0,
                            "target": "52-45"
                        },
                        {
                            "yaw": -1.5498608057547774,
                            "pitch": 0.020664580233727747,
                            "rotation": 0,
                            "target": "11-10"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "54-47",
                    "name": "47",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.7466644613514788,
                        "pitch": 0.3198444029891636,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 1.5983031860314538,
                            "pitch": 0.07384026986040482,
                            "rotation": 0,
                            "target": "6-6"
                        },
                        {
                            "yaw": 0.054775463212614284,
                            "pitch": 0.08063289477696323,
                            "rotation": 0,
                            "target": "55-48"
                        },
                        {
                            "yaw": -3.0509893090276634,
                            "pitch": 0.03398049264464298,
                            "rotation": 0,
                            "target": "52-45"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "55-48",
                    "name": "48",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "yaw": 0.8093290060456688,
                        "pitch": 0.33687565669706565,
                        "fov": 1.2597446215024068
                    },
                    "linkHotspots": [{
                            "yaw": 1.8066798236969444,
                            "pitch": 0.06276696810422777,
                            "rotation": 0,
                            "target": "56-49"
                        },
                        {
                            "yaw": -3.028489522364625,
                            "pitch": 0.015821220720265927,
                            "rotation": 0,
                            "target": "54-47"
                        },
                        {
                            "yaw": -0.1207657745811268,
                            "pitch": 0.11394711042731132,
                            "rotation": 0,
                            "target": "57-51"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "56-49",
                    "name": "49",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": -0.04164374148871097,
                            "pitch": 0.05205708706372825,
                            "rotation": 0,
                            "target": "4-5"
                        },
                        {
                            "yaw": 3.1115198958710977,
                            "pitch": -0.04433729220842153,
                            "rotation": 0,
                            "target": "55-48"
                        }
                    ],
                    "infoHotspots": []
                },
                {
                    "id": "57-51",
                    "name": "51",
                    "levels": [{
                            "tileSize": 256,
                            "size": 256,
                            "fallbackOnly": true
                        },
                        {
                            "tileSize": 512,
                            "size": 512
                        },
                        {
                            "tileSize": 512,
                            "size": 1024
                        },
                        {
                            "tileSize": 512,
                            "size": 2048
                        }
                    ],
                    "faceSize": 2048,
                    "initialViewParameters": {
                        "pitch": 0,
                        "yaw": 0,
                        "fov": 1.5707963267948966
                    },
                    "linkHotspots": [{
                            "yaw": 3.0527185062603897,
                            "pitch": 0.009551713526153804,
                            "rotation": 0,
                            "target": "56-49"
                        },
                        {
                            "yaw": -0.07581803278696952,
                            "pitch": 0.1021263071581906,
                            "rotation": 0,
                            "target": "3-4"
                        }
                    ],
                    "infoHotspots": []
                }
            ],
            "name": "Project Title",
            "settings": {
                "mouseViewMode": "drag",
                "autorotateEnabled": false,
                "fullscreenButton": false,
                "viewControlButtons": false
            }
        };
        var p1 = "{{ $vista1->project }}";
        var s1 = "{{ $vista1->hotspot }}";
        var p2 = "{{ $vista2->project }}";
        var s2 = "{{ $vista2->hotspot }}";
        // alert(p1 + " " + s1 + " " + p2 + " " + s2);

document.addEventListener('DOMContentLoaded', function() {
    var scenaSelect = document.getElementById('scenas');
    if (!scenaSelect) {
        console.error('❌ No se encontró el elemento <select id="scenas">');
        return;
    }

    // Verifica que las variables estén disponibles
    if (typeof APP_DATA_El_ENCANTO === 'undefined' || typeof APP_DATA_CCL === 'undefined') {
        console.error('❌ APP_DATA_El_ENCANTO o APP_DATA_CCL no están definidos aún');
        return;
    }

    optgroups = scenaSelect.getElementsByTagName('optgroup');

    for (var i = 0; i < optgroups.length; i++) {
        // 🔸 Opcional: comenta esta línea si quieres que se vean los optgroups
        // optgroups[i].style.display = 'none';

        if (optgroups[i].id === 'ElEncanto1') {
            for (var j = 0; j < APP_DATA_El_ENCANTO.scenes.length; j++) {
                var option = document.createElement('option');
                option.value = APP_DATA_El_ENCANTO.scenes[j].id;
                option.text = APP_DATA_El_ENCANTO.scenes[j].name;
                optgroups[i].appendChild(option);
            }
        }
        else if (optgroups[i].id === 'ccl') {
            for (var j = 0; j < APP_DATA_CCL.scenes.length; j++) {
                var option = document.createElement('option');
                option.value = APP_DATA_CCL.scenes[j].id;
                option.text = APP_DATA_CCL.scenes[j].name;
                optgroups[i].appendChild(option);
            }
        }
    }

    scenaSelect = document.getElementById('scenas2');
    var optgroups = scenaSelect.getElementsByTagName('optgroup');

    for (var i = 0; i < optgroups.length; i++) {
        // 🔸 Opcional: comenta esta línea si quieres que se vean los optgroups
        // optgroups[i].style.display = 'none';
        if (optgroups[i].id === 'ElEncanto2') {
            for (var j = 0; j < APP_DATA_El_ENCANTO.scenes.length; j++) {
                var option = document.createElement('option');
                option.value = APP_DATA_El_ENCANTO.scenes[j].id;
                option.text = APP_DATA_El_ENCANTO.scenes[j].name;
                optgroups[i].appendChild(option);
            }
        }
        else if (optgroups[i].id === 'ccl2') {
            for (var j = 0; j < APP_DATA_CCL.scenes.length; j++) {
                var option = document.createElement('option');
                option.value = APP_DATA_CCL.scenes[j].id;
                option.text = APP_DATA_CCL.scenes[j].name;
                optgroups[i].appendChild(option);
            }
        }
    }
});


        document.getElementById('project').addEventListener('change', function() {
            var selectedProject = this.value;
            var scenaSelect = document.getElementById('scenas');
            var optgroups = scenaSelect.getElementsByTagName('optgroup');
            if (selectedProject === 'proyecto1') {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    if (optgroups[i].id === 'ElEncanto1') {
                        optgroups[i].style.display = 'block';
                    } else {
                        optgroups[i].style.display = 'none';
                    }
                }
            } else if (selectedProject === 'proyecto2') {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    if (optgroups[i].id === 'ccl') {
                        optgroups[i].style.display = 'block';
                    } else {
                        optgroups[i].style.display = 'none';
                    }
                }
            } else {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    optgroups[i].style.display = 'none';
                }
            }
        });

        document.getElementById('project2').addEventListener('change', function() {
            var selectedProject = this.value;
            var scenaSelect = document.getElementById('scenas2');
            var optgroups = scenaSelect.getElementsByTagName('optgroup');
            if (selectedProject === 'proyecto1') {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    if (optgroups[i].id === 'ElEncanto2') {
                        optgroups[i].style.display = 'block';
                    } else {
                        optgroups[i].style.display = 'none';
                    }
                }
            } else if (selectedProject === 'proyecto2') {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    if (optgroups[i].id === 'ccl2') {
                        optgroups[i].style.display = 'block';
                    } else {
                        optgroups[i].style.display = 'none';
                    }
                }
            } else {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    optgroups[i].style.display = 'none';
                }
            }
        });
        document.addEventListener('DOMContentLoaded', function() {
            var projectSelect = document.getElementById('project');
            var projectOptions = projectSelect.getElementsByTagName('option');
            for (var i = 0; i < projectOptions.length; i++) {
                if (projectOptions[i].value == p1) {
                    projectOptions[i].setAttribute('selected', 'selected');
                }
            }
            var selectedProject = p1;
            var scenaSelect = document.getElementById('scenas');
            var optgroups = scenaSelect.getElementsByTagName('optgroup');
            if (selectedProject === 'proyecto1') {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    if (optgroups[i].id === 'ElEncanto1') {
                        optgroups[i].style.display = 'block';
                    } else {
                        optgroups[i].style.display = 'none';
                    }
                }
            } else if (selectedProject === 'proyecto2') {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    if (optgroups[i].id === 'ccl') {
                        optgroups[i].style.display = 'block';
                    } else {
                        optgroups[i].style.display = 'none';
                    }
                }
            } else {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    optgroups[i].style.display = 'none';
                }
            }
            var scenesSelect = document.getElementById('scenas');
            var scenesOptions = scenesSelect.getElementsByTagName('option');
            for (var i = 0; i < scenesOptions.length; i++) {
                // alert(scenesOptions[i].value + " vs " + s1);
                if (scenesOptions[i].value == s1) {
                    scenesOptions[i].setAttribute('selected', 'selected');
                }
            }



            var projectSelect = document.getElementById('project2');
            var projectOptions = projectSelect.getElementsByTagName('option');
            for (var i = 0; i < projectOptions.length; i++) {
                if (projectOptions[i].value == p2) {
                    projectOptions[i].setAttribute('selected', 'selected');
                }
            }
            var selectedProject = p2;
            var scenaSelect = document.getElementById('scenas2');
            var optgroups = scenaSelect.getElementsByTagName('optgroup');
            if (selectedProject === 'proyecto1') {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    if (optgroups[i].id === 'ElEncanto2') {
                        optgroups[i].style.display = 'block';
                    } else {
                        optgroups[i].style.display = 'none';
                    }
                }
            } else if (selectedProject === 'proyecto2') {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    if (optgroups[i].id === 'ccl2') {
                        optgroups[i].style.display = 'block';
                    } else {
                        optgroups[i].style.display = 'none';
                    }
                }
            } else {
                scenaSelect.value = '';
                for (var i = 0; i < optgroups.length; i++) {
                    optgroups[i].style.display = 'none';
                }
            }
            var scenesSelect2 = document.getElementById('scenas2');
            var scenesOptions2 = scenesSelect2.getElementsByTagName('option');
            for (var i = 0; i < scenesOptions2.length; i++) {
                if (scenesOptions2[i].value == s2) {
                    scenesOptions2[i].setAttribute('selected', 'selected');
                }
            }
        });
    </script>
</body>

</html>
